def bbk_keygen(id_str):
    if len(id_str) != 12:
        return "Error: ID must be 12 chars"

    # --- Part 1: 基础求和逻辑 ---
    sum_val = 0
    for char in id_str:
        sum_val += ord(char)
    
    sum_sq = sum_val * sum_val      # 平方
    sum_cu = sum_val * sum_sq       # 立方 (汇编里其实是 sum * sum * sum)

    # 提取 SumSq 的百十个位 (对应汇编 ebp-11, ebp-12, ebp-13)
    sum_sq_digits = [
        (sum_sq // 100) % 10,
        (sum_sq // 10) % 10,
        sum_sq % 10
    ]

    # 提取 SumCu 的百十个位 (对应汇编 ebp-14, ebp-15, ebp-16)
    # 并且加上 Sum 的百十个位 (对应汇编 004016FF 开始的混合)
    # 这就是 MixA 组
    sum_digits = [(sum_val // 100) % 10, (sum_val // 10) % 10, sum_val % 10]
    cube_digits = [(sum_cu // 100) % 10, (sum_cu // 10) % 10, sum_cu % 10]
    
    mix_a = [
        (cube_digits[0] + sum_digits[0]) % 10,
        (cube_digits[1] + sum_digits[1]) % 10,
        (cube_digits[2] + sum_digits[2]) % 10
    ]

    # --- Part 2 & 3: 局部字符平方逻辑 ---
    # 辅助函数：把3个字符转成数字并平方，提取6位
    def get_square_digits(c1, c2, c3):
        # 汇编逻辑：(char - 48) * 100 + ...
        # 注意：这里接受特殊字符，'A'(65) 会变成 17
        val = (ord(c1) - 48) * 100 + (ord(c2) - 48) * 10 + (ord(c3) - 48)
        sq = val * val
        return [
            (sq // 100000) % 10, # D1/E1
            (sq // 10000) % 10,  # D2/E2
            (sq // 1000) % 10,   # D3/E3
            (sq // 100) % 10,    # D4/E4
            (sq // 10) % 10,     # D5/E5
            sq % 10              # D6/E6
        ]

    # 计算 中三位 (ID[6:9]) 的平方特征 (E1-E6)
    e_digits = get_square_digits(id_str[6], id_str[7], id_str[8])
    
    # 计算 后三位 (ID[9:12]) 的平方特征 (D1-D6)
    d_digits = get_square_digits(id_str[9], id_str[10], id_str[11])

    # --- Part 4: 原始字符干扰 (Raw) ---
    raw_vals = [ord(c) - 48 for c in id_str[6:12]]

    # --- Part 5: 终极混合 (Final Mix) ---
    # 对应汇编 00401980 开始的大乱炖
    # 每一位都是 4 个数字相加
    
    final_code = []
    
    # 第1位: SumSq[0] + D1 + E1 + Raw[0]
    r0 = (sum_sq_digits[0] + d_digits[0] + e_digits[0] + raw_vals[0]) % 10
    final_code.append(str(r0))

    # 第2位: MixA[0] + D2 + E2 + Raw[1]
    r1 = (mix_a[0] + d_digits[1] + e_digits[1] + raw_vals[1]) % 10
    final_code.append(str(r1))

    # 第3位: SumSq[1] + D3 + E3 + Raw[2]
    r2 = (sum_sq_digits[1] + d_digits[2] + e_digits[2] + raw_vals[2]) % 10
    final_code.append(str(r2))

    # 第4位: MixA[1] + D4 + E4 + Raw[3]
    r3 = (mix_a[1] + d_digits[3] + e_digits[3] + raw_vals[3]) % 10
    final_code.append(str(r3))

    # 第5位: SumSq[2] + D5 + E5 + Raw[4]
    r4 = (sum_sq_digits[2] + d_digits[4] + e_digits[4] + raw_vals[4]) % 10
    final_code.append(str(r4))

    # 第6位: MixA[2] + D6 + E6 + Raw[5]
    r5 = (mix_a[2] + d_digits[5] + e_digits[5] + raw_vals[5]) % 10
    final_code.append(str(r5))

    return "".join(final_code)

# 测试验证
target_id = input("请输入12位ID: ")
result = bbk_keygen(target_id)
print(f"ID: {target_id} -> Code: {result}")
'''
if result == "167995":
    print("SUCCESS! 算法完美破解！")
else:
    print("Failed...")
'''